/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.formatter.nodes;

import com.aptana.editor.php.formatter.nodes.FormatterPHPTextNode;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.NodeTypes;

public class FormatterPHPOperatorNode
extends FormatterPHPTextNode {
    private final NodeTypes.TypeOperator nodeType;
    private boolean isUnary;

    public FormatterPHPOperatorNode(IFormatterDocument document, NodeTypes.TypeOperator nodeType, boolean isUnary) {
        super(document, true);
        this.nodeType = nodeType;
        this.isUnary = isUnary;
    }

    @Override
    public int getSpacesCountBefore() {
        if (this.isUnary) {
            return this.getDocument().getInt("php.formatter.spaces.before.unary");
        }
        switch (this.nodeType) {
            case ARROW: {
                return this.getDocument().getInt("php.formatter.spaces.before.arrow");
            }
            case STATIC_INVOCATION: {
                return this.getDocument().getInt("php.formatter.spaces.before.staticInvocation");
            }
            case KEY_VALUE: {
                return this.getDocument().getInt("php.formatter.spaces.before.keyValue");
            }
            case ASSIGNMENT: 
            case DOT_EQUAL: 
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case MULTIPLY_EQUAL: 
            case DIVIDE_EQUAL: 
            case TILDE_EQUAL: 
            case OR_EQUAL: 
            case AND_EQUAL: {
                return this.getDocument().getInt("php.formatter.spaces.before.assignment");
            }
            case GREATER_THAN: 
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN_OR_EQUAL: 
            case EQUAL: 
            case IDENTICAL: 
            case NOT_EQUAL: 
            case NOT_EQUAL_ALTERNATE: 
            case NOT_IDENTICAL: {
                return this.getDocument().getInt("php.formatter.spaces.before.relational");
            }
            case DOT_CONCATENATION: {
                return this.getDocument().getInt("php.formatter.spaces.before.dot");
            }
            case CONDITIONAL: 
            case CONDITIONAL_COLON: {
                return this.getDocument().getInt("php.formatter.spaces.before.conditional");
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                return this.getDocument().getInt("php.formatter.spaces.before.postfix");
            }
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: {
                return this.getDocument().getInt("php.formatter.spaces.before.prefix");
            }
            case MULTIPLY: 
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MODULUS: 
            case OR: 
            case AND: 
            case XOR: 
            case BINARY_OR: 
            case BINARY_AND: {
                return this.getDocument().getInt("php.formatter.spaces.before.arithmetic");
            }
            case OR_LITERAL: 
            case AND_LITERAL: 
            case XOR_LITERAL: {
                return Math.max(1, this.getDocument().getInt("php.formatter.spaces.before.arithmetic"));
            }
            case TILDE: 
            case NOT: {
                return this.getDocument().getInt("php.formatter.spaces.before.unary");
            }
        }
        return super.getSpacesCountBefore();
    }

    @Override
    public int getSpacesCountAfter() {
        if (this.isUnary) {
            return this.getDocument().getInt("php.formatter.spaces.after.unary");
        }
        switch (this.nodeType) {
            case ARROW: {
                return this.getDocument().getInt("php.formatter.spaces.after.arrow");
            }
            case STATIC_INVOCATION: {
                return this.getDocument().getInt("php.formatter.spaces.after.staticInvocation");
            }
            case KEY_VALUE: {
                return this.getDocument().getInt("php.formatter.spaces.after.keyValue");
            }
            case ASSIGNMENT: 
            case DOT_EQUAL: 
            case PLUS_EQUAL: 
            case MINUS_EQUAL: 
            case MULTIPLY_EQUAL: 
            case DIVIDE_EQUAL: 
            case TILDE_EQUAL: 
            case OR_EQUAL: 
            case AND_EQUAL: {
                return this.getDocument().getInt("php.formatter.spaces.after.assignment");
            }
            case GREATER_THAN: 
            case LESS_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN_OR_EQUAL: 
            case EQUAL: 
            case IDENTICAL: 
            case NOT_EQUAL: 
            case NOT_EQUAL_ALTERNATE: 
            case NOT_IDENTICAL: {
                return this.getDocument().getInt("php.formatter.spaces.after.relational");
            }
            case DOT_CONCATENATION: {
                return this.getDocument().getInt("php.formatter.spaces.after.dot");
            }
            case CONDITIONAL: 
            case CONDITIONAL_COLON: {
                return this.getDocument().getInt("php.formatter.spaces.after.conditional");
            }
            case POSTFIX_INCREMENT: 
            case POSTFIX_DECREMENT: {
                return this.getDocument().getInt("php.formatter.spaces.after.postfix");
            }
            case PREFIX_INCREMENT: 
            case PREFIX_DECREMENT: {
                return this.getDocument().getInt("php.formatter.spaces.after.prefix");
            }
            case MULTIPLY: 
            case PLUS: 
            case MINUS: 
            case DIVIDE: 
            case MODULUS: 
            case OR: 
            case AND: 
            case XOR: 
            case BINARY_OR: 
            case BINARY_AND: {
                return this.getDocument().getInt("php.formatter.spaces.after.arithmetic");
            }
            case OR_LITERAL: 
            case AND_LITERAL: 
            case XOR_LITERAL: {
                return Math.max(1, this.getDocument().getInt("php.formatter.spaces.after.arithmetic"));
            }
            case TILDE: 
            case NOT: {
                return this.getDocument().getInt("php.formatter.spaces.after.unary");
            }
        }
        return super.getSpacesCountBefore();
    }
}

